/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.html;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.html.renderer.DelegatingNodeRendererFactory;
import icyllis.flexmark.html.renderer.NodeRenderer;
import icyllis.flexmark.html.renderer.NodeRendererFactory;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.dependency.Dependent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

class DelegatingNodeRendererFactoryWrapper
implements Function<DataHolder, NodeRenderer>,
Dependent,
DelegatingNodeRendererFactory {
    private final NodeRendererFactory nodeRendererFactory;
    private List<DelegatingNodeRendererFactoryWrapper> nodeRenderers;
    private Set<Class<?>> myDelegates = null;

    public DelegatingNodeRendererFactoryWrapper(List<DelegatingNodeRendererFactoryWrapper> nodeRenderers, NodeRendererFactory nodeRendererFactory) {
        this.nodeRendererFactory = nodeRendererFactory;
        this.nodeRenderers = nodeRenderers;
    }

    @Override
    @NotNull
    public NodeRenderer apply(@NotNull DataHolder options) {
        return this.nodeRendererFactory.apply(options);
    }

    @NotNull
    public NodeRendererFactory getFactory() {
        return this.nodeRendererFactory;
    }

    @Override
    @Nullable
    public Set<Class<?>> getDelegates() {
        return this.nodeRendererFactory instanceof DelegatingNodeRendererFactory ? ((DelegatingNodeRendererFactory)this.nodeRendererFactory).getDelegates() : null;
    }

    @Override
    @Nullable
    public final Set<Class<?>> getAfterDependents() {
        return null;
    }

    @Override
    @Nullable
    public Set<Class<?>> getBeforeDependents() {
        if (this.myDelegates == null && this.nodeRenderers != null) {
            Set<Class<?>> delegates = this.getDelegates();
            if (delegates != null) {
                this.myDelegates = new HashSet();
                for (DelegatingNodeRendererFactoryWrapper factory : this.nodeRenderers) {
                    if (!delegates.contains(factory.getFactory().getClass())) continue;
                    this.myDelegates.add(factory.getFactory().getClass());
                }
            }
            this.nodeRenderers = null;
        }
        return this.myDelegates;
    }

    @Override
    public final boolean affectsGlobalScope() {
        return false;
    }
}

